package ru.yandex.direct.logicprocessor.processors.moderation.special.flags;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.service.sending.banner.ModerationFlagsConverter;
import ru.yandex.direct.ess.logicobjects.moderation.special.ModerationFlagsEvent;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Конвертирует сырое событие из роутера в представление для отправки в модерацию через LogBroker.
 */
@Component
public class ModerationFlagsEventConverter {

    private final ModerationFlagsConverter moderationFlagsConverter;

    @Autowired
    public ModerationFlagsEventConverter(ModerationFlagsConverter moderationFlagsConverter) {
        this.moderationFlagsConverter = moderationFlagsConverter;
    }

    public ModerationFlagsRequest convert(ModerationFlagsEvent event) {
        checkNotNull(event.getCampaignId(), "ModerationDeletionEvent.campaignId");
        checkNotNull(event.getAdGroupId(), "ModerationDeletionEvent.adGroupId");
        checkNotNull(event.getBannerId(), "ModerationDeletionEvent.bannerId");
        checkNotNull(event.getEventTime(), "ModerationDeletionEvent.eventTime");

        ModerationFlagsRequest request = new ModerationFlagsRequest();
        request.setCampaignId(event.getCampaignId());
        request.setAdGroupId(event.getAdGroupId());
        request.setBannerId(event.getBannerId());
        request.setUnixtime(event.getEventTime());
        request.setFlags(moderationFlagsConverter.convertFlags(event.getBannerId(), event.getFlags()));

        return request;
    }
}
