package ru.yandex.direct.logicprocessor.processors.moderation.special.flags;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.container.ModerationLogEntry;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestLogEntryCreator;

@Component
public class ModerationFlagsLogEntryCreator
        implements ModerationRequestLogEntryCreator<ModerationFlagsRequest> {

    @Override
    public <E extends ModerationFlagsRequest> ModerationLogEntry<E> createLogEntry(E moderationRequest) {
        return new ModerationLogEntry<>(moderationRequest.getCampaignId(), moderationRequest.getAdGroupId(),
                moderationRequest.getBannerId(), ModerationLogEntry.Action.REQUEST, true, moderationRequest);
    }
}
