package ru.yandex.direct.logicprocessor.processors.moderation.turbolandings;

import java.util.Objects;

import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesAdgroupType;
import ru.yandex.direct.ess.logicobjects.moderation.turbolandings.TurbolandingsModerationEventsObject;

public class TurbolandingsModerationEventWithTypesInfo {

    private final TurbolandingsModerationEventsObject eventsObject;
    private final PhrasesAdgroupType adGroupType;
    private final BannersBannerType bannerType;

    public TurbolandingsModerationEventWithTypesInfo(
            TurbolandingsModerationEventsObject eventsObject,
            PhrasesAdgroupType adGroupType, BannersBannerType bannerType)
    {
        this.eventsObject = eventsObject;
        this.adGroupType = adGroupType;
        this.bannerType = bannerType;
    }

    public TurbolandingsModerationEventsObject getEventsObject() {
        return eventsObject;
    }

    public PhrasesAdgroupType getAdGroupType() {
        return adGroupType;
    }

    public BannersBannerType getBannerType() {
        return bannerType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TurbolandingsModerationEventWithTypesInfo that = (TurbolandingsModerationEventWithTypesInfo) o;
        return Objects.equals(eventsObject, that.eventsObject) &&
                adGroupType == that.adGroupType &&
                bannerType == that.bannerType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(eventsObject, adGroupType, bannerType);
    }
}
