package ru.yandex.direct.logicprocessor.processors.moderation.turbolandings;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.turbolandings.TurbolandingModerationRequest;
import ru.yandex.direct.core.entity.moderation.service.sending.TurbolandingSender;
import ru.yandex.direct.core.entity.turbolanding.model.TurboLandingWithModerationInfo;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesAdgroupType;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.banner.TurbolandingsModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.turbolandings.TurbolandingsModerationEventsObject;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.BannerAssetSimpleModerationEventsProcessor;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.TurbolandingsModerationWriter;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_1, DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class, tags =
        {DIRECT_PRIORITY_1})
@EssLogicProcessor(TurbolandingsModerationConfig.class)
public class TurbolandingsModerationEventsProcessor extends BannerAssetSimpleModerationEventsProcessor
        <TurbolandingsModerationEventsObject, TurboLandingWithModerationInfo, TurbolandingModerationRequest> {
    private final TurbolandingsModerationEventsService turbolandingsModerationEventsService;

    @Autowired
    public TurbolandingsModerationEventsProcessor(
            EssLogicProcessorContext essLogicProcessorContext,
            TurbolandingsModerationEventsService turbolandingsModerationEventsService,
            TurbolandingSender turbolandingSender, TurbolandingsModerationWriter moderationWriter,
            ModerationWriterMonitoring moderationWriterMonitoring,
            ModerationOperationModeProvider moderationOperationModeProvider) {

        super(essLogicProcessorContext, turbolandingSender, moderationWriter, moderationWriterMonitoring,
                moderationOperationModeProvider);

        this.turbolandingsModerationEventsService = turbolandingsModerationEventsService;
    }

    @Override
    protected List<Long> getObjectIds(List<TurbolandingsModerationEventsObject> events) {
        List<TurbolandingsModerationEventWithTypesInfo> eventsWithInfo = turbolandingsModerationEventsService
                .mapEventsToTurbolandingsWithInfo(getShard(), events);

        return eventsWithInfo.stream()
                //cpm_yndx_fronpages are handled with CpmBannerModerationEventsProcessor as part of banner
                .filter(o -> o.getAdGroupType() != PhrasesAdgroupType.cpm_yndx_frontpage)
                .map(o -> o.getEventsObject().getBannerId()).collect(Collectors.toList());
    }

}
