package ru.yandex.direct.logicprocessor.processors.moderation.turbolandings;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.banner.repository.BannerRelationsRepository;
import ru.yandex.direct.ess.logicobjects.moderation.turbolandings.TurbolandingsModerationEventsObject;

import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@Service
public class TurbolandingsModerationEventsService {

    private final BannerRelationsRepository bannerRelationsRepository;

    @Autowired
    public TurbolandingsModerationEventsService(
            BannerRelationsRepository bannerRelationsRepository) {
        this.bannerRelationsRepository = bannerRelationsRepository;
    }

    public List<TurbolandingsModerationEventWithTypesInfo> mapEventsToTurbolandingsWithInfo(int shard,
                                                                                            List<TurbolandingsModerationEventsObject> objects) {
        Set<Long> bids = listToSet(objects, TurbolandingsModerationEventsObject::getBannerId);

        Map<Long, BannerRelationsRepository.BannerAndPhrasesTypes> bannerTypeMap =
                bannerRelationsRepository.getBidToTypeMap(shard, bids);

        return objects.stream()
                .filter(e -> bannerTypeMap.containsKey(e.getBannerId()))
                .map(e ->
                        new TurbolandingsModerationEventWithTypesInfo(e,
                                bannerTypeMap.get(e.getBannerId()).getPhrasesAdgroupType(),
                                bannerTypeMap.get(e.getBannerId()).getBannersBannerType()))
                .collect(Collectors.toList());
    }
}
