package ru.yandex.direct.logicprocessor.processors.moderation.writers

import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.beans.factory.config.ConfigurableBeanFactory
import org.springframework.context.annotation.Scope
import org.springframework.stereotype.Component
import ru.yandex.direct.common.log.service.ModerationLogService
import ru.yandex.direct.core.entity.moderation.model.asset.BannerMulticardModerationRequest
import ru.yandex.direct.env.EnvironmentType
import ru.yandex.direct.ess.common.logbroker.LogbrokerClientFactoryFacade
import ru.yandex.direct.ess.common.logbroker.LogbrokerProducerProperties
import ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration.MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME
import ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration.MODERATION_LOGBROKER_PRODUCERS_PROPERTIES_BANNER_MULTICARD_REQUEST
import ru.yandex.direct.logicprocessor.processors.moderation.BannerModerationRequestLogEntryCreator
import ru.yandex.direct.logicprocessor.processors.moderation.CampaignIdPartitionGroupComputer
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestFilter

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
class BannerMulticardModerationWriter(
    environmentType: EnvironmentType,
    moderationRequestFilter: ModerationRequestFilter,
    @Qualifier(MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME)
    logbrokerClientFactoryFacade: LogbrokerClientFactoryFacade,
    bannerModerationRequestLogEntryCreator: BannerModerationRequestLogEntryCreator,
    moderationLogService: ModerationLogService,
    @Qualifier(MODERATION_LOGBROKER_PRODUCERS_PROPERTIES_BANNER_MULTICARD_REQUEST)
    producerProperties: List<LogbrokerProducerProperties>,
    campaignIdPartitionGroupComputer: CampaignIdPartitionGroupComputer,
) : ModerationRequestsWriterImpl<BannerMulticardModerationRequest>(
    environmentType,
    moderationRequestFilter,
    logbrokerClientFactoryFacade,
    bannerModerationRequestLogEntryCreator,
    moderationLogService,
    producerProperties,
    campaignIdPartitionGroupComputer,
    "banner-multicard-moderation",
    "banner-multicard",
)
