package ru.yandex.direct.logicprocessor.processors.moderation.writers;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.service.ModerationLogService;
import ru.yandex.direct.core.entity.moderation.model.callout.CalloutModerationRequest;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.ess.common.logbroker.LogbrokerClientFactoryFacade;
import ru.yandex.direct.ess.common.logbroker.LogbrokerProducerProperties;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestFilter;
import ru.yandex.direct.logicprocessor.processors.moderation.callout.CalloutModerationLogEntryCreator;
import ru.yandex.direct.logicprocessor.processors.moderation.callout.CalloutPartitionGroupComputer;


import static ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration.MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME;
import static ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration.MODERATION_LOGBROKER_PRODUCERS_PROPERTIES_CALLOUT_REQUEST;

@Component
@Scope(value = ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class CalloutModerationWriter extends ModerationRequestsWriterImpl<CalloutModerationRequest> {
    private final static String CALLOUT_MODERATION_PREFIX = "callout-moderation";


    @Autowired
    public CalloutModerationWriter(
            EnvironmentType environmentType,
            ModerationRequestFilter filter,
            @Qualifier(MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME)
                    LogbrokerClientFactoryFacade logbrokerClientFactory,
            CalloutModerationLogEntryCreator calloutModerationLogEntryCreator,
            ModerationLogService moderationLogService,
            @Qualifier(MODERATION_LOGBROKER_PRODUCERS_PROPERTIES_CALLOUT_REQUEST)
                    List<LogbrokerProducerProperties> producersProperties,
            CalloutPartitionGroupComputer calloutPartitionGroupComputer
    ) {
        super(environmentType,
                filter,
                logbrokerClientFactory,
                calloutModerationLogEntryCreator,
                moderationLogService,
                producersProperties,
                calloutPartitionGroupComputer,
                CALLOUT_MODERATION_PREFIX,
                "callout");
    }
}
