package ru.yandex.direct.logicprocessor.processors.moderation.writers;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.service.ModerationLogService;
import ru.yandex.direct.core.entity.moderation.model.verdictrequest.contentpromotion.ContentPromotionModerationVerdictRequest;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.ess.common.logbroker.LogbrokerClientFactoryFacade;
import ru.yandex.direct.ess.common.logbroker.LogbrokerProducerProperties;
import ru.yandex.direct.logicprocessor.processors.moderation.CampaignIdPartitionGroupComputer;
import ru.yandex.direct.logicprocessor.processors.moderation.ContentPromotionAccessibilityModerationRequestLogEntryCreator;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestFilter;

import static ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration.MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME;
import static ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration.MODERATION_LOGBROKER_PRODUCERS_PROPERTIES_VERDICT_REQUEST;

@Component
@Scope(value = ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class ContentPromotionAccessibilityModerationWriter
        extends ModerationRequestsWriterImpl<ContentPromotionModerationVerdictRequest> {

    private static final String LOGBROKER_PREFIX = "content_promotion_accessibility";

    @Autowired
    public ContentPromotionAccessibilityModerationWriter(
            EnvironmentType environmentType,
            ModerationRequestFilter filter,
            @Qualifier(MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME)
                    LogbrokerClientFactoryFacade logbrokerClientFactory,
            ContentPromotionAccessibilityModerationRequestLogEntryCreator logEntryCreator,
            ModerationLogService moderationLogService,
            @Qualifier(MODERATION_LOGBROKER_PRODUCERS_PROPERTIES_VERDICT_REQUEST)
                    List<LogbrokerProducerProperties> producersProperties,
            CampaignIdPartitionGroupComputer campaignIdPartitionGroupComputer
    ) {
        super(environmentType,
                filter,
                logbrokerClientFactory,
                logEntryCreator,
                moderationLogService,
                producersProperties,
                campaignIdPartitionGroupComputer,
                LOGBROKER_PREFIX,
                "");
    }
}
