package ru.yandex.direct.logicprocessor.processors.moderation.writers;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.service.ModerationLogService;
import ru.yandex.direct.core.entity.moderation.model.image.ImageModerationRequest;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.ess.common.logbroker.LogbrokerClientFactoryFacade;
import ru.yandex.direct.ess.common.logbroker.LogbrokerProducerProperties;
import ru.yandex.direct.logicprocessor.processors.moderation.BannerModerationRequestLogEntryCreator;
import ru.yandex.direct.logicprocessor.processors.moderation.CampaignIdPartitionGroupComputer;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestFilter;

import static ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration.MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME;
import static ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration.MODERATION_LOGBROKER_PRODUCERS_PROPERTIES_IMAGE_REQUEST;

@Component
@Scope(value = ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class ImageModerationWriter extends ModerationRequestsWriterImpl<ImageModerationRequest> {

    private final static String IMAGE_LOGBROKER_PREFIX = "image-moderation";

    @Autowired
    public ImageModerationWriter(
            EnvironmentType environmentType,
            ModerationRequestFilter filter,
            @Qualifier(MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME)
                    LogbrokerClientFactoryFacade logbrokerClientFactory,
            BannerModerationRequestLogEntryCreator bannerModerationRequestLogEntryCreator,
            ModerationLogService moderationLogService,
            @Qualifier(MODERATION_LOGBROKER_PRODUCERS_PROPERTIES_IMAGE_REQUEST)
                    List<LogbrokerProducerProperties> producersProperties,
            CampaignIdPartitionGroupComputer campaignIdPartitionGroupComputer
    ) {
        super(environmentType,
                filter,
                logbrokerClientFactory,
                bannerModerationRequestLogEntryCreator,
                moderationLogService,
                producersProperties,
                campaignIdPartitionGroupComputer,
                IMAGE_LOGBROKER_PREFIX,
                "image");
    }
}
