package ru.yandex.direct.logicprocessor.processors.moderation.writers;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.service.ModerationLogService;
import ru.yandex.direct.core.entity.moderation.model.mobilecontenticon.MobileContentIconModerationRequest;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.ess.common.logbroker.LogbrokerClientFactoryFacade;
import ru.yandex.direct.ess.common.logbroker.LogbrokerProducerProperties;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestFilter;
import ru.yandex.direct.logicprocessor.processors.moderation.mobilecontenticon.MobileContentIconModerationLogEntryCreator;
import ru.yandex.direct.logicprocessor.processors.moderation.mobilecontenticon.MobileContentIconPartitionGroupComputer;

import static ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration.MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME;
import static ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration.MODERATION_LOGBROKER_PRODUCERS_PROPERTIES_MOBILE_CONTENT_ICON_REQUEST;

@Component
@Scope(value = ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class MobileContentIconModerationWriter
        extends ModerationRequestsWriterImpl<MobileContentIconModerationRequest> {
    private final static String MOBILE_CONTENT_ICON_MODERATION_PREFIX = "mobile-content-icon-moderation";

    @Autowired
    public MobileContentIconModerationWriter(
            EnvironmentType environmentType,
            ModerationRequestFilter filter,
            @Qualifier(MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME)
                    LogbrokerClientFactoryFacade logbrokerClientFactory,
            MobileContentIconModerationLogEntryCreator mobileContentIconModerationLogEntryCreator,
            ModerationLogService moderationLogService,
            @Qualifier(MODERATION_LOGBROKER_PRODUCERS_PROPERTIES_MOBILE_CONTENT_ICON_REQUEST)
                    List<LogbrokerProducerProperties> producersProperties,
            MobileContentIconPartitionGroupComputer mobileContentIconPartitionGroupComputer
    ) {
        super(environmentType,
                filter,
                logbrokerClientFactory,
                mobileContentIconModerationLogEntryCreator,
                moderationLogService,
                producersProperties,
                mobileContentIconPartitionGroupComputer,
                MOBILE_CONTENT_ICON_MODERATION_PREFIX,
                "mobile_content_icon");
    }
}
