package ru.yandex.direct.logicprocessor.processors.moderation.writers;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.solomon.SolomonPushClient;
import ru.yandex.direct.solomon.SolomonUtils;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

@ParametersAreNonnullByDefault
@Component
public class ModerationWriterMonitoring {

    private static final Logger logger = LoggerFactory.getLogger(ModerationWriterMonitoring.class);

    private static final String MODERATION_REQUEST_COUNT = "moderation_request_count";

    private final SolomonPushClient solomonPushClient;
    private final MetricRegistry metricRegistry;

    @Autowired
    public ModerationWriterMonitoring(SolomonPushClient solomonPushClient) {
        this.solomonPushClient = solomonPushClient;
        this.metricRegistry = SolomonUtils.newPushRegistry();
    }

    public int incModerationRequestCount(int newRequestsCount, Labels labels) {
        try {
            metricRegistry.gaugeInt64(MODERATION_REQUEST_COUNT, labels).set(newRequestsCount);
            solomonPushClient.sendMetrics(metricRegistry);
            metricRegistry.gaugeInt64(MODERATION_REQUEST_COUNT, labels).set(0);
        } catch (RuntimeException ex) {
            logger.error("fail to send solomon metrics", ex);
        }
        return newRequestsCount;
    }
}
