package ru.yandex.direct.logicprocessor.processors.moderation.writers

import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.beans.factory.config.ConfigurableBeanFactory
import org.springframework.context.annotation.Scope
import org.springframework.stereotype.Component
import ru.yandex.direct.common.log.service.ModerationLogService
import ru.yandex.direct.core.entity.moderation.model.promoextension.PromoExtensionModerationRequest
import ru.yandex.direct.env.EnvironmentType
import ru.yandex.direct.ess.common.logbroker.LogbrokerClientFactoryFacade
import ru.yandex.direct.ess.common.logbroker.LogbrokerProducerProperties
import ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration.*
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestFilter
import ru.yandex.direct.logicprocessor.processors.moderation.promoaction.PromoactionModerationLogEntryCreator
import ru.yandex.direct.logicprocessor.processors.moderation.promoaction.PromoactionPartitionGroupComputer

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
class PromoactionModerationWriter(
    environmentType: EnvironmentType,
    moderationRequestFilter: ModerationRequestFilter,
    @Qualifier(MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME)
    logbrokerClientFactoryFacade: LogbrokerClientFactoryFacade,
    promoactionModerationLogEntryCreator: PromoactionModerationLogEntryCreator,
    moderationLogService: ModerationLogService,
    @Qualifier(MODERATION_LOGBROKER_PRODUCERS_PROPERTIES_PROMO_EXTENSION_REQUEST)
    producerProperties: List<LogbrokerProducerProperties>,
    promoactionPartitionGroupComputer: PromoactionPartitionGroupComputer,
) : ModerationRequestsWriterImpl<PromoExtensionModerationRequest>(
    environmentType,
    moderationRequestFilter,
    logbrokerClientFactoryFacade,
    promoactionModerationLogEntryCreator,
    moderationLogService,
    producerProperties,
    promoactionPartitionGroupComputer,
    "moderation",
    "promoextensions",
)
