package ru.yandex.direct.logicprocessor.processors.mysql2grut

import org.slf4j.LoggerFactory
import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.env.NonDevelopmentEnvironment
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.env.TestingOnly
import ru.yandex.direct.ess.config.mysql2grut.Mysql2GrutReplicationConfig
import ru.yandex.direct.ess.logicobjects.mysql2grut.Mysql2GrutReplicationObject
import ru.yandex.direct.juggler.JugglerStatus
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.CheckTag
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.logicprocessor.common.BaseLogicProcessorNotScheduled
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext
import ru.yandex.direct.logicprocessor.processors.mysql2grut.replicationwriter.ReplicationWriterService
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.scheduler.HourglassDaemon
import ru.yandex.direct.utils.JsonUtils
import ru.yandex.direct.utils.ThreadUtils
import java.time.Duration

@JugglerCheck(
    ttl = JugglerCheck.Duration(minutes = 5),
    needCheck = ProductionOnly::class,
    tags = [CheckTag.DIRECT_PRIORITY_0],
    notifications = [
        OnChangeNotification(
            recipient = [NotificationRecipient.LOGIN_MSPIRIT, NotificationRecipient.LOGIN_PPALEX, NotificationRecipient.LOGIN_A_BELIAKOV],
            status = [JugglerStatus.OK, JugglerStatus.CRIT],
            method = [NotificationMethod.TELEGRAM]
        )
    ]
)
@JugglerCheck(ttl = JugglerCheck.Duration(minutes = 15), needCheck = TestingOnly::class)
@EssLogicProcessor(Mysql2GrutReplicationConfig::class)
@HourglassDaemon(runPeriod = 0)
@Hourglass(periodInSeconds = 0, needSchedule = NonDevelopmentEnvironment::class)
class Mysql2GrutReplicationProcessor(
    essLogicProcessorContext: EssLogicProcessorContext,
    private val replicationWriterService: ReplicationWriterService
) : BaseLogicProcessorNotScheduled<Mysql2GrutReplicationObject>(essLogicProcessorContext) {

    companion object {
        private val logger = LoggerFactory.getLogger(Mysql2GrutReplicationProcessor::class.java)
    }

    override fun process(logicObjects: List<Mysql2GrutReplicationObject>) {
        try {
            replicationWriterService.writeObjects(shard, logicObjects)
        } catch (e: Exception) {
            logger.error("Unexpected exception on input ${JsonUtils.toJsonIgnoringNullFields(logicObjects)}", e)
            // Небольшое ожидание, чтобы не забивать логи в случае повторяющихся ошибок
            ThreadUtils.sleep(Duration.ofSeconds(5))
            throw e
        }
    }
}
