package ru.yandex.direct.logicprocessor.processors.mysql2grut.replicationwriter

import java.time.Duration
import java.util.concurrent.TimeUnit
import com.google.common.base.Suppliers
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.timetarget.model.GeoTimezone
import ru.yandex.direct.core.entity.timetarget.repository.GeoTimezoneRepository

@Component
class TimezoneCache(geoTimezoneRepository: GeoTimezoneRepository, expirationTime: Duration = Duration.ofHours(1)) {
    private val supplier = geoTimezoneRepository::getAllTimezones
    private val timezonesCache = if (expirationTime == Duration.ZERO) supplier
    else Suppliers.memoizeWithExpiration(supplier,
            expirationTime.seconds, TimeUnit.SECONDS)::get

    operator fun get(timezoneId: Long): GeoTimezone? {
        return timezonesCache()[timezoneId]
    }
}
