package ru.yandex.direct.logicprocessor.processors.mysql2grut.replicationwriter

import org.slf4j.Logger
import org.slf4j.LoggerFactory
import org.springframework.beans.factory.annotation.Value
import org.springframework.stereotype.Component
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.core.entity.additionaltargetings.repository.CampAdditionalTargetingsRepository
import ru.yandex.direct.core.entity.bs.common.service.BsOrderIdCalculator
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign
import ru.yandex.direct.core.entity.campaign.model.WalletTypedCampaign
import ru.yandex.direct.core.entity.campaign.service.CampaignAutobudgetRestartService
import ru.yandex.direct.core.entity.campaign.service.WalletHasMoneyChecker
import ru.yandex.direct.core.entity.metrika.repository.MetrikaCampaignRepository
import ru.yandex.direct.core.entity.mobileapp.service.IosSkAdNetworkSlotManager
import ru.yandex.direct.core.grut.replication.GrutApiService
import ru.yandex.direct.ess.logicobjects.mysql2grut.Mysql2GrutReplicationObject
import ru.yandex.direct.logicprocessor.processors.bsexport.utils.SupportedCampaignsService
import ru.yandex.direct.logicprocessor.processors.mysql2grut.repository.CampOrderTypesRepository

@Component
class WalletReplicationWriter(
    private val campaignTypedRepository: SupportedCampaignsService,
    objectApiService: GrutApiService,
    timezoneCache: TimezoneCache,
    campOrderTypesRepository: CampOrderTypesRepository,
    autobudgetRestartService: CampaignAutobudgetRestartService,
    metrikaCampaignRepository: MetrikaCampaignRepository,
    bsOrderIdCalculator: BsOrderIdCalculator,
    walletHasMoneyChecker: WalletHasMoneyChecker,
    campaignAdditionalTargetingsRepository: CampAdditionalTargetingsRepository,
    @Value("\${grut_replication.calc_autobudget_restarts_threads:1}") calcAutobudgetRestartsThreadPoolSize: Int,
    skAdNetworkSlotManager: IosSkAdNetworkSlotManager,
    ppcPropertiesSupport: PpcPropertiesSupport,
) : BaseCampaignReplicationWriter(
    campaignTypedRepository,
    objectApiService,
    timezoneCache,
    campOrderTypesRepository,
    autobudgetRestartService,
    metrikaCampaignRepository,
    bsOrderIdCalculator,
    walletHasMoneyChecker,
    campaignAdditionalTargetingsRepository,
    calcAutobudgetRestartsThreadPoolSize,
    skAdNetworkSlotManager,
    ppcPropertiesSupport
) {

    companion object {
        private val walletLogger = LoggerFactory.getLogger(WalletReplicationWriter::class.java)
    }

    override val logger: Logger = walletLogger

    // Все удаления будут делаться в writer'е кампаний

    override fun getObjectsForDelete(objects: Collection<Mysql2GrutReplicationObject>) =
        listOf<Mysql2GrutReplicationObject>()

    override fun getMissingSpecificForeignEntities(
        shard: Int,
        objects: Collection<CampaignWriterData>
    ): Collection<Mysql2GrutReplicationObject> = listOf()

    override fun getNotExistingInMysqlObjects(
        shard: Int,
        objects: Collection<CampaignWriterData>
    ): Collection<CampaignWriterData> {
        return listOf()
    }

    // Все удаления будут делаться в writer'е кампаний
    override fun deleteObjectsInGrut(objects: Collection<CampaignWriterData>) {
    }

    override fun filterSpecificEntities(
        shard: Int,
        objects: Collection<CampaignWriterData>
    ) = objects

    override fun getCampaigns(shard: Int, campaignIds: Collection<Long>): List<CommonCampaign> {
        return campaignTypedRepository.getSafely(shard, campaignIds, WalletTypedCampaign::class.java)
    }
}
