package ru.yandex.direct.logicprocessor.processors.mysql2grut.repository

import org.springframework.stereotype.Repository
import ru.yandex.direct.dbschema.ppc.Tables.CAMP_ORDER_TYPES
import ru.yandex.direct.dbutil.wrapper.DslContextProvider

@Repository
class CampOrderTypesRepository(private val dslContextProvider: DslContextProvider) {

    fun getCampsOrderType(shard: Int, campaignIds: Collection<Long>): Map<Long, Int> {
        return dslContextProvider.ppc(shard)
            .select(CAMP_ORDER_TYPES.CID, CAMP_ORDER_TYPES.ORDER_TYPE)
            .from(CAMP_ORDER_TYPES)
            .where(CAMP_ORDER_TYPES.CID.`in`(campaignIds))
            .fetchMap(CAMP_ORDER_TYPES.CID, CAMP_ORDER_TYPES.ORDER_TYPE)
            .mapValues { it.value.toInt() }
    }

}
