package ru.yandex.direct.logicprocessor.processors.promocodescheckcampaignchanges;


import java.util.List;

import com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.promocodescheckcampaignchanges.PromocodesCheckCampaignChangesConfig;
import ru.yandex.direct.ess.logicobjects.promocodescheckcampaignchanges.PromocodesCheckCampaignChangesObject;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.logicprocessor.common.BaseLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1_NOT_READY;
import static ru.yandex.direct.juggler.check.model.CheckTag.GROUP_INTERNAL_SYSTEMS;
import static ru.yandex.direct.juggler.check.model.NotificationRecipient.CHAT_INTERNAL_SYSTEMS_MONITORING;

@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        notifications = {
                @OnChangeNotification(recipient = CHAT_INTERNAL_SYSTEMS_MONITORING,
                        status = {JugglerStatus.OK, JugglerStatus.CRIT},
                        method = NotificationMethod.TELEGRAM),
        },
        //PRIORITY: Временно поставили приоритет по умолчанию;
        tags = {DIRECT_PRIORITY_1_NOT_READY, GROUP_INTERNAL_SYSTEMS}
)
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = NonProductionEnvironment.class,
        //PRIORITY: Временно поставили приоритет по умолчанию;
        tags = {DIRECT_PRIORITY_1_NOT_READY, GROUP_INTERNAL_SYSTEMS}
)
@EssLogicProcessor(PromocodesCheckCampaignChangesConfig.class)
public class PromocodesCheckCampaignChangesProcessor extends BaseLogicProcessor<PromocodesCheckCampaignChangesObject> {

    private static final Logger logger = LoggerFactory.getLogger(PromocodesCheckCampaignChangesProcessor.class);
    private static final Joiner JOINER = Joiner.on(", ");

    private final PromocodesCheckCampaignChangesService promocodesCheckCampaignChangesSevice;

    @Autowired
    public PromocodesCheckCampaignChangesProcessor(
            EssLogicProcessorContext essLogicProcessorContext,
            PromocodesCheckCampaignChangesService promocodesCheckCampaignChangesSevice) {
        super(essLogicProcessorContext);
        this.promocodesCheckCampaignChangesSevice = promocodesCheckCampaignChangesSevice;
    }

    @Override
    public void process(List<PromocodesCheckCampaignChangesObject> objects) {
        var badCids = promocodesCheckCampaignChangesSevice.processObjects(getShard(), objects);
        if (!badCids.isEmpty()) {
            String msg = "Не удалось оторвать промокод для кампаний: " + JOINER.join(badCids);
            logger.debug(msg);
            setJugglerStatus(JugglerStatus.CRIT, msg);
        }
    }
}
