package ru.yandex.direct.logicprocessor.processors.recomtracer.cancellers.pages;

import java.util.Arrays;
import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.recommendation.RecommendationType;
import ru.yandex.direct.ess.logicobjects.recomtracer.AdditionalColumns;
import ru.yandex.direct.logicprocessor.processors.recomtracer.RecommendationKeyWithAdditionalColumns;
import ru.yandex.direct.logicprocessor.processors.recomtracer.cancellers.RecommendationCanceller;

import static com.google.common.base.Preconditions.checkState;
import static java.util.stream.Collectors.toSet;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;

@Component
public class RemovePagesFromBlackListCanceller implements RecommendationCanceller {
    @Override
    public RecommendationType supportedType() {
        return RecommendationType.removePagesFromBlackListOfACampaign;
    }

    @Override
    public boolean recommendationsToCancel(RecommendationKeyWithAdditionalColumns recommendationKeyWithAdditionalColumns) {
        AdditionalColumns additionalColumns = recommendationKeyWithAdditionalColumns.getAdditionalColumns();
        if (!additionalColumns.contains(CAMPAIGNS.DONT_SHOW)) {
            return true;
        }
        String dontShow = additionalColumns.get(CAMPAIGNS.DONT_SHOW);
        Set<String> pages = parsePages(dontShow);
        return !pages.contains(recommendationKeyWithAdditionalColumns.getRecommendationKey().getUserKey1());
    }

    /**
     * Извлекает множество площадок из строки, в которой они перечислены через запятую
     */
    private static Set<String> parsePages(String pages) {
        checkState(pages != null);
        return Arrays.stream(pages.split(",", -1)).filter(s -> !s.isEmpty()).collect(toSet());
    }
}
