# event-sourcing-system-router

Router читает бинлоги из LogBroker-топика, применяет пользовательские правила, записывает данные в следующие топики. Каждый объект записывается в LogBroker в группу, равную номеру шарда из бинлога
Гарантируется, что все сообщения, считаенные обработанные объекты будут записаны в последующие топики ровно один раз.

### Создание правила фильтрации бинлогов
Правило фильтрации - класс наследуемый от класса [AbstractRule](src/main/java/ru/yandex/direct/ess/router/models/rule/AbstractRule.java). Для фильтрации нужно реализовать метод mapBinlogEvent, принимающий на вход бинлог, и возвращающий список определенных пользователем объектов, полученных в результате обработки бинлога, или пустой список, если бинлог не подошел.
Класс для правила параметризуется пользовательским объектом, и должен быть помечен аннотацией [EssRule](src/main/java/ru/yandex/direct/ess/router/models/rule/EssRule.java) с параметром - классом конфигурации цепочки(см BaseEssConfig)

Правила должны отфильтровывать события только на основе значений полей бинлога, нельзя ходить с базу, другие сервисы и тп.
Для удобства можно использовать классы [TableChange](src/main/java/ru/yandex/direct/ess/router/utils/TableChange.java) и [TableChangesHandler](src/main/java/ru/yandex/direct/ess/router/utils/TableChangesHandler.java)
