package ru.yandex.direct.ess.router;

import com.beust.jcommander.ParameterException;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

import ru.yandex.direct.ess.router.components.EventSourcingSystemRouterAppRunnable;
import ru.yandex.direct.ess.router.configuration.AppJcommanderConfiguration;
import ru.yandex.direct.ess.router.configuration.RouterApplicationConfiguration;
import ru.yandex.direct.ess.router.configuration.commandline.AppParams;
import ru.yandex.direct.ess.router.models.EssWorkMode;
import ru.yandex.direct.jcommander.ParserWithHelp;
import ru.yandex.direct.logging.LoggingInitializer;
import ru.yandex.direct.tracing.TraceGuard;
import ru.yandex.direct.tracing.TraceHelper;

import static ru.yandex.direct.ess.router.configuration.RouterApplicationConfiguration.METHOD_TEMPL;


public class EventSourcingSystemRouterApp {

    private static final String SERVICE = "direct.ess-router";

    public static void main(String[] args) {

        AppParams params = new AppParams();
        ParserWithHelp.parse(EventSourcingSystemRouterApp.class.getCanonicalName(), args, params);

        try {
            params.validate();
        } catch (ParameterException exc) {
            ParserWithHelp.printErrorAndExit(exc);
        }

        LoggingInitializer
                .initialize(params.loggingInitializerParams, SERVICE);
        AppJcommanderConfiguration.initializeParameters(params);


        try (AnnotationConfigApplicationContext context =
                     new AnnotationConfigApplicationContext(RouterApplicationConfiguration.class)) {
            EssWorkMode workMode = context.getBean(EssWorkMode.class);
            String methodName = String.format(METHOD_TEMPL, workMode.getChunk());

            TraceHelper traceHelper = context.getBean(TraceHelper.class);
            try (TraceGuard traceGuard = traceHelper.guard(methodName)) {
                context.getBean(EventSourcingSystemRouterAppRunnable.class).run();
            }
        }
    }
}
