package ru.yandex.direct.ess.router.components

import org.slf4j.LoggerFactory
import org.springframework.context.ConfigurableApplicationContext
import org.springframework.stereotype.Component
import ru.yandex.direct.ytwrapper.chooser.AppDestroyer
import kotlin.concurrent.thread
import kotlin.system.exitProcess

@Component
class EssAppDestroyer(
    private val context: ConfigurableApplicationContext
) : AppDestroyer {

    private val logger = LoggerFactory.getLogger(EssAppDestroyer::class.java)

    private var exception: Exception? = null

    private fun destroyApp() {
        thread(isDaemon = true, name = "EssAppDestroyerThread") {
            try {
                Thread.sleep(10000)
            } catch (e: InterruptedException) {
                // nothing
            } finally {
                logger.info("Destroying app using halt")
                Runtime.getRuntime().halt(APP_DESTROYED)
            }
        }
        context.close()
        logger.info("Context closed, destroying app using exit")
        exitProcess(APP_DESTROYED)
    }

    override fun destroy(exception: Exception) {
        this.exception = exception
        logger.info("App destroyed with exception {}", exception)
        destroyApp()
    }

    override fun hasError() = exception != null

    override fun getError() = exception

    private companion object {
        const val APP_DESTROYED = 12345
    }
}
