package ru.yandex.direct.ess.router.components;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlogbroker.logbroker_utils.writer.AbstractLogbrokerWriterImpl;
import ru.yandex.direct.binlogbroker.logbroker_utils.writer.LogbrokerWriterRetryConfig;
import ru.yandex.direct.ess.router.models.rule.ProcessedObject;
import ru.yandex.kikimr.persqueue.producer.AsyncProducer;


@ParametersAreNonnullByDefault
public class LogicObjectLogbrokerWriter extends AbstractLogbrokerWriterImpl<ProcessedObject> {


    public LogicObjectLogbrokerWriter(Supplier<CompletableFuture<AsyncProducer>> logbrokerProducerSupplier, Duration logbrokerTimeout,
                                      int retries) {
        super(logbrokerProducerSupplier, logbrokerTimeout, new LogbrokerWriterRetryConfig(retries));
    }


    @Override
    protected LogbrokerWriteRequest makeRequest(ProcessedObject record) {
        return new LogbrokerWriteRequest(record.getLogicObjectWithSystemInfo(), record.getSeqNo());
    }
}
