package ru.yandex.direct.ess.router.components;

import org.springframework.stereotype.Component;

import ru.yandex.monlib.metrics.registry.MetricRegistry;

@Component
public class RouterWatchlogMonitoring extends RouterMonitoring {

    public RouterWatchlogMonitoring(MetricRegistry metricRegistry) {
        super(metricRegistry);
    }

    @Override
    String getDelayMetricName() {
        return "watchlog_delay";
    }

    @Override
    String getProcessedLogicObjectsMetricName() {
        return "watchlog_processed_logic_objects";
    }

    @Override
    String getAdditionalLogicObjectsMetricName() {
        return "watchlog_additional_logic_objects";
    }

    @Override
    String getSkippedAdditionalLogicObjectsMetricName() {
        return "watchlog_skipped_additional_logic_objects";
    }

    @Override
    String getRowCountMetricName() {
        return "watchlog_handled_binlog_rows_count";
    }

    @Override
    String getWritingMessagesMetricName() {
        return "watchlog_writing_messages";
    }

    @Override
    String getWritingDurationMetricName() {
        return "watchlog_writing_duration";
    }
}
