package ru.yandex.direct.ess.router.components

import com.google.protobuf.InvalidProtocolBufferException
import com.google.protobuf.TextFormat
import java.util.function.Supplier
import org.slf4j.LoggerFactory
import ru.yandex.direct.binlogbroker.logbroker_utils.reader.impl.LogbrokerBatchReaderImpl
import ru.yandex.direct.ess.router.models.TEssEvent
import ru.yandex.direct.ess.router.models.WatchlogEvent
import ru.yandex.direct.tracing.Trace
import ru.yandex.kikimr.persqueue.consumer.SyncConsumer
import ru.yandex.kikimr.persqueue.consumer.transport.message.inbound.data.MessageBatch

class WatchlogLogbrokerReader(
    logbrokerConsumerSupplier: Supplier<SyncConsumer>,
    logbrokerNoCommit: Boolean,
) : LogbrokerBatchReaderImpl<WatchlogEvent>(logbrokerConsumerSupplier, logbrokerNoCommit) {

    companion object {
        private val logger = LoggerFactory.getLogger(WatchlogLogbrokerReader::class.java)
    }

    override fun batchDeserialize(messageBatch: MessageBatch): List<WatchlogEvent> {
        return Trace.current().profile("watchlog_logbroker_reader.deserialize").use {
            val data = mutableListOf<WatchlogEvent>()
            val partition = messageBatch.partition

            for (messageData in messageBatch.messageData) {
                val watchlogEvent = try {
                    WatchlogEvent(
                        event = TEssEvent.parseFrom(messageData.decompressedData),
                        partition = partition,
                        seqNo = messageData.messageMeta.seqNo,
                    )
                } catch (e: InvalidProtocolBufferException) {
                    logger.error("Got error parsing message", e)
                    continue
                }

                logger.debug("Object - {}", TextFormat.shortDebugString(watchlogEvent.event))
                data.add(watchlogEvent)
            }

            data
        }
    }

    override fun count(e: MutableList<WatchlogEvent>) = e.size
}
