package ru.yandex.direct.ess.router.config;

import java.util.Objects;

public class LogbrokerWriterAdditionalConfig {
    private String topic;
    private Integer group;
    private Integer partition;
    private boolean forWatchlog;

    private LogbrokerWriterAdditionalConfig() {
    }

    public String getTopic() {
        return topic;
    }

    public Integer getGroup() {
        return group;
    }

    public Integer getPartition() {
        return partition;
    }

    public boolean isForWatchlog() {
        return forWatchlog;
    }

    @Override
    public String toString() {
        return "LogbrokerWriterAdditionalConfig{"
                + "topic=" + topic
                + "partition=" + partition
                + "forWatchlog=" + forWatchlog
                + "}";
    }

    @Override
    public int hashCode() {
        return Objects.hash(topic, partition, forWatchlog);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || getClass() != obj.getClass()) {
            return false;
        }
        LogbrokerWriterAdditionalConfig that = (LogbrokerWriterAdditionalConfig) obj;
        return Objects.equals(topic, that.topic)
                && Objects.equals(partition, that.partition)
                && forWatchlog == that.forWatchlog;
    }

    public static LogbrokerWriterAdditionalConfig fromTopicAndPartition(String topic, Integer partition) {
        return fromTopicAndPartition(topic, partition, false);
    }

    public static LogbrokerWriterAdditionalConfig fromTopicAndPartition(String topic, Integer partition, boolean forWatchlog) {
        LogbrokerWriterAdditionalConfig logbrokerWriterAdditionalConfig = new LogbrokerWriterAdditionalConfig();
        logbrokerWriterAdditionalConfig.topic = topic;
        logbrokerWriterAdditionalConfig.partition = partition;
        logbrokerWriterAdditionalConfig.group = partition + 1;
        logbrokerWriterAdditionalConfig.forWatchlog = forWatchlog;
        return logbrokerWriterAdditionalConfig;
    }
}
