package ru.yandex.direct.ess.router.config;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Preconditions;

import ru.yandex.direct.ess.common.logbroker.LogbrokerConsumerProperties;


@ParametersAreNonnullByDefault
public class RouterLogbrokerConsumerProperties implements LogbrokerConsumerProperties {

    private final String host;
    private final String topic;
    private final String consumerName;
    private final List<Integer> groups;
    private final long readDataTimeoutSec;
    private final long initTimeoutSec;
    private final int retries;
    private final boolean readOnlyNewData;
    private final Long readDataOnlyAfterTimestampMs;
    private final int maxCount;
    private int readBufferSize;


    protected RouterLogbrokerConsumerProperties(String host, String topic, String consumerName, List<Integer> groups,
                                                long readDataTimeoutSec, long initTimeoutSec, int retryCount,
                                                boolean readOnlyNewData, Long readDataOnlyAfterTimestampMs,
                                                int maxCount, int readBufferSize) {
        this.host = host;
        this.topic = topic;
        this.consumerName = consumerName;
        this.groups = groups;
        this.readDataTimeoutSec = readDataTimeoutSec;
        this.initTimeoutSec = initTimeoutSec;
        this.retries = retryCount;
        this.readOnlyNewData = readOnlyNewData;
        this.readDataOnlyAfterTimestampMs = readDataOnlyAfterTimestampMs;
        this.maxCount = maxCount;
        this.readBufferSize = readBufferSize;
    }

    @Override
    public String getHost() {
        return host;
    }

    @Override
    public String getReadTopic() {
        return topic;
    }

    @Override
    public String getConsumerName() {
        return consumerName;
    }

    @Override
    public List<Integer> getGroups() {
        return groups;
    }

    @Override
    public long getReadDataTimeoutSec() {
        return readDataTimeoutSec;
    }

    @Override
    public long getInitTimeoutSec() {
        return initTimeoutSec;
    }

    @Override
    public boolean readOnlyNewData() {
        return readOnlyNewData;
    }

    @Override
    public Long getReadDataOnlyAfterTimestampMs() {
        return readDataOnlyAfterTimestampMs;
    }

    @Override
    public int getRetries() {
        return retries;
    }

    @Override
    public int getMaxCount() {
        return maxCount;
    }

    @Override
    public int getReadBufferSize() {
        return readBufferSize;
    }

    public static class Builder {
        private String host;
        private String topic;
        private String consumerName;
        private List<Integer> groups;
        private Long readDataTimeoutSec;
        private Long initTimeoutSec;
        private Integer retries;
        private boolean readOnlyNewData = false;
        private Long readDataOnlyAfterTimestampMs;
        private int maxCount;
        private int readBufferSize;

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder setConsumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public Builder setGroups(List<Integer> groups) {
            this.groups = groups;
            return this;
        }

        public Builder setReadDataTimeoutSec(long readDataTimeoutSec) {
            this.readDataTimeoutSec = readDataTimeoutSec;
            return this;
        }

        public Builder setInitTimeoutSec(long initTimeoutSec) {
            this.initTimeoutSec = initTimeoutSec;
            return this;
        }

        public Builder setRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public Builder setReadOnlyNewData(boolean readOnlyNewData) {
            this.readOnlyNewData = readOnlyNewData;
            return this;
        }

        public Builder readDataOnlyAfterTimestampMs(Long readDataOnlyAfterTimestampMs) {
            this.readDataOnlyAfterTimestampMs = readDataOnlyAfterTimestampMs;
            return this;
        }

        public Builder setMaxCount(int maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public Builder setReadBufferSize(int readBufferSize) {
            this.readBufferSize = readBufferSize;
            return this;
        }

        public RouterLogbrokerConsumerProperties build() {
            Preconditions.checkState(host != null, "forgotten host");
            Preconditions.checkState(topic != null, "forgotten topic");
            Preconditions.checkState(consumerName != null, "forgotten consumerName");
            Preconditions.checkState(groups != null, "forgotten groups");
            Preconditions.checkState(readDataTimeoutSec != null, "forgotten timeout");
            Preconditions.checkState(initTimeoutSec != null, "forgotten initTimeout");
            Preconditions.checkState(retries != null, "forgotten retries");
            return new RouterLogbrokerConsumerProperties(host, topic, consumerName, groups, readDataTimeoutSec,
                    initTimeoutSec, retries, readOnlyNewData, readDataOnlyAfterTimestampMs, maxCount, readBufferSize);
        }

    }
}
