package ru.yandex.direct.ess.router.configuration;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

import ru.yandex.direct.config.EssentialConfiguration;
import ru.yandex.direct.ess.router.configuration.commandline.AppParams;
import ru.yandex.direct.ess.router.configuration.commandline.LogbrokerParams;

import static com.fasterxml.jackson.databind.PropertyNamingStrategy.SNAKE_CASE;
import static ru.yandex.direct.config.EssentialConfiguration.OVERRIDING_CONFIG_BEAN_NAME;


/**
 * spring-configuration for import arguments from command line to context
 */
@Configuration
@Import({
        EssentialConfiguration.class,
})
@ParametersAreNonnullByDefault
public class AppJcommanderConfiguration {

    private static AppParams appParams;

    public static void initializeParameters(AppParams appParams) {
        AppJcommanderConfiguration.appParams = appParams;
    }

    // Lazy(false) - Автоматическая проверка, что метод не забыли позвать. Если захотелось отключить эту проверку, то
    // стоит совсем избавиться от этой конфигурации.
    @Bean
    @Lazy(false)
    public AppParams appParams() {
        Preconditions.checkState(appParams != null,
                "You forgot to call %s.initializeParameters()", getClass().getName());
        return appParams;
    }

    /**
     * Параметры appParams будут доступны в typesafe-config-е (и в spring-properties) как app_params.ess_tag=...
     */
    @Bean(OVERRIDING_CONFIG_BEAN_NAME)
    public Config overridingConfig() throws JsonProcessingException {
        var jsonMapper = new ObjectMapper()
                .setPropertyNamingStrategy(SNAKE_CASE);
        var config = Map.of("app_params", appParams());
        return ConfigFactory.parseString(jsonMapper.writeValueAsString(config));
    }

    @Bean
    public LogbrokerParams logbrokerParams(AppParams params) {
        return params.logbrokerParams;
    }
}
