package ru.yandex.direct.ess.router.configuration.commandline;

import javax.annotation.ParametersAreNonnullByDefault;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;

import ru.yandex.direct.logging.LoggingInitializerParams;


@ParametersAreNonnullByDefault
public class AppParams {

    @ParametersDelegate
    public LoggingInitializerParams loggingInitializerParams = new LoggingInitializerParams();

    @ParametersDelegate
    public LogbrokerParams logbrokerParams = new LogbrokerParams();

    @Parameter(
            names = {"--ess-tag"},
            description = "Sql queries with this tag will be processed by ess. If not specified, only requests with " +
                    "an empty tag will be processed."
    )
    public String essTag = "";

    public void validate() {
        logbrokerParams.validate();
    }
}
