package ru.yandex.direct.ess.router.models;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

import javax.annotation.Nonnull;

import ru.yandex.direct.binlogbroker.logbroker_utils.models.BinlogEventWithOffset;

import static java.util.stream.Collectors.toList;

public class BinlogEventsFilter {
    private Predicate<BinlogEventWithOffset> filter;

    private BinlogEventsFilter() {
    }

    public BinlogEventsFilter(@Nonnull Predicate<BinlogEventWithOffset> filter) {
        this.filter = filter;
    }

    public List<BinlogEventWithOffset> filter(List<BinlogEventWithOffset> events) {
        return Objects.isNull(filter) ? events :
                events.stream().filter(filter).collect(toList());
    }

    public void addFilter(Predicate<BinlogEventWithOffset> newFilter) {
        if (Objects.isNull(filter)) {
            filter = newFilter;
        }
        this.filter = filter.and(newFilter);
    }

    public static BinlogEventsFilter doNothing() {
        return new BinlogEventsFilter();
    }
}
