package ru.yandex.direct.ess.router.models

enum class EssWorkMode(val chunk: Int) {
    // при добавлении новых work mode может понадобиться нестандартно перезапускать приложение, см. https://st.yandex-team.ru/DIRECT-160414
    ESS_0(0),
    ESS_1(1),
    ESS_2(2),
    ESS_3(3);

    open fun getShards(totalShards: Collection<Int>): List<Int> {
        return totalShards.asSequence()
            .filter { shard -> shard % CHUNKS_COUNT == chunk }
            .toList()
    }

    override fun toString(): String {
        return chunk.toString()
    }

    companion object {
        val CHUNKS_COUNT = values().size
    }
}
