package ru.yandex.direct.ess.router.models

import ru.yandex.grut.watchlog.Watch.TEvent
import ru.yandex.inside.yt.kosher.common.YtTimestamp

data class WatchlogEvent(
    val event: TEssEvent,
    val partition: Int,
    val seqNo: Long,
)

fun WatchlogEvent.getUtcTimestamp(): Long = event.event.getUtcTimestamp()
fun TEvent.getUtcTimestamp(): Long = YtTimestamp.valueOf(timestamp).instant.epochSecond
