package ru.yandex.direct.ess.router.models.rule;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.stereotype.Component;

import ru.yandex.direct.env.TypicalEnvironment;
import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.utils.Condition;


/**
 * Аннотация, которой помечаются пользовательские правила обработки бинлога.
 * Параметр - пользовательский конфиг ess, наследуемый от {@link BaseEssConfig} класс
 */
@Component
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface EssRule {
    Class<? extends BaseEssConfig> value();

    Class<? extends Condition> runCondition() default TypicalEnvironment.class;
}
