package ru.yandex.direct.ess.router.models.rule;

import java.util.List;

import ru.yandex.direct.ess.common.converter.LogicObjectWithSystemInfoConverter;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.common.models.LogicObjectListWithInfo;

import static ru.yandex.direct.ess.common.converter.LogicObjectWithSystemInfoConverter.getDefaultConverter;

public class ProcessedObject {

    private final long seqNo;
    private final byte[] logicObjectWithSystemInfo;

    private static final LogicObjectWithSystemInfoConverter<BaseLogicObject> logicObjectWithSystemInfoConverter =
            getDefaultConverter();

    public ProcessedObject(
            long seqNo,
            byte[] logicObjectWithSystemInfo
    ) {
        this.seqNo = seqNo;
        this.logicObjectWithSystemInfo = logicObjectWithSystemInfo;
    }

    public long getSeqNo() {
        return seqNo;
    }

    public byte[] getLogicObjectWithSystemInfo() {
        return logicObjectWithSystemInfo;
    }

    /**
     * Создает объект, для обозначения того, что причина отсутствия данных в lb - отсутствие подходящих бинлогов, а
     * не отсутсвие вообще
     * Такой объект не содежрит данных, он призван передать текущее отставание от бинлога
     */
    public static List<ProcessedObject> createPingProceededObjects(long seqNo, long timestamp) {
        LogicObjectListWithInfo<BaseLogicObject> pingLogicObject = new LogicObjectListWithInfo.Builder<>()
                .withUtcTimestamp(timestamp)
                .withSeqNo(seqNo)
                .pingObject()
                .build();
        byte[] pingLogicObjectJson = logicObjectWithSystemInfoConverter.toJson(pingLogicObject);
        return List.of(new ProcessedObject(seqNo, pingLogicObjectJson));
    }
}
