package ru.yandex.direct.ess.router.models.rule;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;


public class RuleProcessingResult {

    private final String topic;
    private final Map<Integer, List<ProcessedObject>> groupedLogicObjectsByPartitions;
    private final Map<Integer, RuleProcessingStat> groupedStatByPartitions;


    public RuleProcessingResult(
            String topic,
            Map<Integer, List<ProcessedObject>> logicObjectsByPartitions,
            Map<Integer, RuleProcessingStat> groupedStatByPartitions) {
        this.topic = topic;
        this.groupedLogicObjectsByPartitions = logicObjectsByPartitions;
        this.groupedStatByPartitions = groupedStatByPartitions;
    }


    public String getTopic() {
        return topic;
    }


    public Map<Integer, List<ProcessedObject>> getGroupedLogicObjectsByPartitions() {
        return groupedLogicObjectsByPartitions;
    }

    public Map<Integer, RuleProcessingStat> getGroupedStatByPartitions() {
        return groupedStatByPartitions;
    }

    public List<ProcessedObject> getProcessedObjectsOrCompute(int partition,
                                                              Supplier<List<ProcessedObject>> processedObjectsCreator) {
        List<ProcessedObject> result = groupedLogicObjectsByPartitions.get(partition);
        return result != null ? result : processedObjectsCreator.get();
    }
}
