package ru.yandex.direct.ess.router.models.rule;

public class RuleProcessingStat {
    private final long processedObjectsCnt;
    private final long additionalObjectsCnt;
    private final long additionalSkippedCnt;

    private RuleProcessingStat(long processedObjectsCnt, long additionalObjectsCnt, long additionalSkippedCnt) {
        this.processedObjectsCnt = processedObjectsCnt;
        this.additionalObjectsCnt = additionalObjectsCnt;
        this.additionalSkippedCnt = additionalSkippedCnt;
    }

    public long getProcessedObjectsCnt() {
        return processedObjectsCnt;
    }

    public long getAdditionalObjectsCnt() {
        return additionalObjectsCnt;
    }

    public long getAdditionalSkippedCnt() {
        return additionalSkippedCnt;
    }

    public static class Builder {
        private long processedObjectsCnt = 0L;
        private long additionalObjectsCnt = 0L;
        private long additionalSkippedCnt = 0L;


        public Builder setProcessedObjectsCnt(long processedObjectsCnt) {
            this.processedObjectsCnt = processedObjectsCnt;
            return this;
        }

        public Builder setAdditionalObjectsCnt(long additionalObjectsCnt) {
            this.additionalObjectsCnt = additionalObjectsCnt;
            return this;
        }

        public Builder setAdditionalSkippedCnt(long additionalSkippedCnt) {
            this.additionalSkippedCnt = additionalSkippedCnt;
            return this;
        }


        public RuleProcessingStat build() {
            return new RuleProcessingStat(processedObjectsCnt, additionalObjectsCnt, additionalSkippedCnt);
        }
    }
}
