package ru.yandex.direct.ess.router.models.rule;

import java.util.List;
import java.util.function.Consumer;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlog.model.BinlogEvent;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

/**
 * Сабклассы должны вызвать tableChangesHandler.addTableChange чтобы начать слушать необходимые им таблицы.
 */
@ParametersAreNonnullByDefault
public class StandardRule<T extends BaseLogicObject> extends AbstractRule<T> {

    private final TableChangesHandler<T> tableChangesHandler = new TableChangesHandler<>();

    public StandardRule(Consumer<TableChangesHandler<T>> handlerInitializer) {
        handlerInitializer.accept(tableChangesHandler);
    }

    @Override
    public final List<T> mapBinlogEvent(BinlogEvent event) {
        return tableChangesHandler.processChanges(event);
    }

}
