package ru.yandex.direct.ess.router.rules.bsexport.adgroup

import ru.yandex.direct.binlog.model.BinlogEvent
import ru.yandex.direct.ess.config.bsexport.adgroup.BsExportAdGroupConfig
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.ess.router.models.rule.AbstractRule
import ru.yandex.direct.ess.router.models.rule.EssRule
import ru.yandex.direct.ess.router.rules.bsexport.adgroup.filter.AdGroupResourceFilter
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@EssRule(BsExportAdGroupConfig::class)
class BsExportAdGroupRule(filters: List<AdGroupResourceFilter>) : AbstractRule<BsExportAdGroupObject>() {
    private val tableChangesHandler: TableChangesHandler<BsExportAdGroupObject> = TableChangesHandler()

    init {
        filters.forEach { it.configure(tableChangesHandler) }
    }

    override fun mapBinlogEvent(binlogEvent: BinlogEvent): List<BsExportAdGroupObject> {
        return tableChangesHandler.processChanges(binlogEvent).distinct()
    }
}
