package ru.yandex.direct.ess.router.rules.bsexport.adgroup

import ru.yandex.direct.binlog.model.BinlogEvent
import ru.yandex.direct.ess.config.bsexport.adgroup.BsExportAdGroupShowConditionConfig
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject
import ru.yandex.direct.ess.router.models.rule.AbstractRule
import ru.yandex.direct.ess.router.models.rule.EssRule
import ru.yandex.direct.ess.router.rules.bsexport.adgroup.showconditions.AdGroupShowConditionFilter
import ru.yandex.direct.ess.router.utils.TableChangesHandler


@EssRule(BsExportAdGroupShowConditionConfig::class)
class BsExportAdGroupShowConditionRule(
    filters: List<AdGroupShowConditionFilter>
) : AbstractRule<BsExportAdGroupShowConditionObject>() {

    private val tableChangesHandler: TableChangesHandler<BsExportAdGroupShowConditionObject> = TableChangesHandler()

    init {
        filters.forEach { it.configure(tableChangesHandler) }
    }

    override fun mapBinlogEvent(binlogEvent: BinlogEvent): List<BsExportAdGroupShowConditionObject> {
        return tableChangesHandler.processChanges(binlogEvent)
    }
}
