package ru.yandex.direct.ess.router.rules.bsexport.adgroup.filter

import org.jooq.Field
import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupClickUrlTailFilter : AdGroupResourceFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupObject>) {
        val handlers: List<TableChange.Builder<BsExportAdGroupObject>.() -> Unit> = listOf(
            {
                setTable(Tables.PHRASES)
                setOperation(Operation.INSERT)
                setMapper {
                    mapToAdGroupObject(it, Tables.PHRASES.PID, Tables.PHRASES.CID)
                }
            },
            {
                setTable(Tables.GROUP_PARAMS)
                setOperation(Operation.INSERT)
                setMapper { mapToAdGroupObject(it, Tables.GROUP_PARAMS.PID) }
            },
            {
                setTable(Tables.GROUP_PARAMS)
                setOperation(Operation.UPDATE)
                setColumn(Tables.GROUP_PARAMS.HREF_PARAMS)
                setMapper { mapToAdGroupObject(it, Tables.GROUP_PARAMS.PID) }
            },
            {
                setTable(CAMPAIGNS)
                setOperation(Operation.UPDATE)
                setColumn(CAMPAIGNS.NAME)
                setMapper { mapToCampaignObject(it) }
            }
        )

        for (handler in handlers) {
            tableChangesHandler.addTableChange(
                TableChange.Builder<BsExportAdGroupObject>().apply(handler).build()
            )
        }
    }

    private fun mapToCampaignObject(
        change: ProceededChange
    ) = BsExportAdGroupObject(
        resourceType = AdGroupResourceType.CLICK_URL_TAIL,
        adGroupId = null,
        campaignId = change.getPrimaryKey(CAMPAIGNS.CID),
        debugInfo = extractDebugInfo(change),
    )

    private fun mapToAdGroupObject(
        change: ProceededChange,
        pid: Field<Long>,
        cid: Field<Long>? = null,
    ) = BsExportAdGroupObject(
        resourceType = AdGroupResourceType.CLICK_URL_TAIL,
        adGroupId = change.getPrimaryKey(pid),
        campaignId = cid?.let { change.getAfter(it) },
        debugInfo = extractDebugInfo(change),
    )
}
