package ru.yandex.direct.ess.router.rules.bsexport.adgroup.filter

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.PHRASES
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType.COMMON_FIELDS
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ColumnsChangeType.ANY
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupCommonFieldsFilter : AdGroupResourceFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(PHRASES)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapToCommonFieldsEvent)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(PHRASES)
                .setColumns(ANY, listOf(PHRASES.GROUP_NAME))
                .setOperation(Operation.UPDATE)
                .setMapper(this::mapToCommonFieldsEvent)
                .build()
        )
    }

    private fun mapToCommonFieldsEvent(proceededChange: ProceededChange): BsExportAdGroupObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(PHRASES.PID)
        val campaignId: Long = proceededChange.getBeforeOrAfter(PHRASES.CID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupObject(COMMON_FIELDS, adGroupId, campaignId, debugInfo)
    }
}
