package ru.yandex.direct.ess.router.rules.bsexport.adgroup.filter

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.ADGROUPS_INTERNAL
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ColumnsChangeType.ANY
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupInternalFieldsFilter : AdGroupResourceFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(ADGROUPS_INTERNAL)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(ADGROUPS_INTERNAL)
                .setOperation(Operation.UPDATE)
                .setColumns(
                    ANY,
                    listOf(
                        ADGROUPS_INTERNAL.LEVEL,
                        ADGROUPS_INTERNAL.RF,
                        ADGROUPS_INTERNAL.RF_RESET,
                        ADGROUPS_INTERNAL.MAX_CLICKS_COUNT,
                        ADGROUPS_INTERNAL.MAX_CLICKS_PERIOD,
                        ADGROUPS_INTERNAL.MAX_STOPS_COUNT,
                        ADGROUPS_INTERNAL.MAX_STOPS_PERIOD
                    )
                )
                .setMapper(this::mapToObject)
                .build()
        )
    }

    private fun mapToObject(proceededChange: ProceededChange): BsExportAdGroupObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(ADGROUPS_INTERNAL.PID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupObject(AdGroupResourceType.INTERNAL_AD_FIELDS, adGroupId, null, debugInfo)
    }
}
