package ru.yandex.direct.ess.router.rules.bsexport.adgroup.filter

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupMatchPriorityFilter : AdGroupResourceFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupObject>) {
        val handlers: List<TableChange.Builder<BsExportAdGroupObject>.() -> Unit> = listOf(
            {
                setTable(Tables.PHRASES)
                setOperation(Operation.INSERT)
                setMapper { mapToAdGroupTypeObject(it) }
            },
            {
                setTable(Tables.ADGROUP_PRIORITY)
                setOperation(Operation.INSERT)
                setMapper { mapToPriorityObject(it) }
            },
            {
                setTable(Tables.ADGROUP_PRIORITY)
                setOperation(Operation.UPDATE)
                setMapper { mapToPriorityObject(it) }
            }
        )

        for (handler in handlers) {
            tableChangesHandler.addTableChange(
                TableChange.Builder<BsExportAdGroupObject>().apply(handler).build()
            )
        }
    }

    private fun mapToAdGroupTypeObject(
        proceededChange: ProceededChange,
    ): BsExportAdGroupObject {
        return BsExportAdGroupObject(
            AdGroupResourceType.MATCH_PRIORITY,
            adGroupId = proceededChange.getPrimaryKey(Tables.PHRASES.PID),
            campaignId = proceededChange.getAfter(Tables.PHRASES.CID),
            debugInfo = extractDebugInfo(proceededChange),
        )
    }

    private fun mapToPriorityObject(
        proceededChange: ProceededChange,
    ): BsExportAdGroupObject {
        return BsExportAdGroupObject(
            AdGroupResourceType.MATCH_PRIORITY,
            adGroupId = proceededChange.getPrimaryKey(Tables.ADGROUP_PRIORITY.PID),
            campaignId = null,
            debugInfo = extractDebugInfo(proceededChange),
        )
    }
}
