package ru.yandex.direct.ess.router.rules.bsexport.adgroup.filter

import org.jooq.Field
import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.MinusPhrasesInfo
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupMinusPhrasesFilter : AdGroupResourceFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(Tables.PHRASES)
                .setOperation(Operation.INSERT)
                .setMapper { change -> mapToPhrasesObject(change, Tables.PHRASES.PID, Tables.PHRASES.CID) }
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(Tables.PHRASES)
                .setOperation(Operation.UPDATE)
                .setColumn(Tables.PHRASES.MW_ID)
                .setMapper { change -> mapToPhrasesObject(change, Tables.PHRASES.PID, Tables.PHRASES.CID) }
                .build()
        )

        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(Tables.MINUS_WORDS)
                .setOperation(Operation.UPDATE)
                .setColumn(Tables.MINUS_WORDS.MW_TEXT)
                .setMapper(this::mapToMinusWordsObject)
                .build()
        )

        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(Tables.ADGROUPS_MINUS_WORDS)
                .setOperation(Operation.INSERT)
                .setMapper { change -> mapToPhrasesObject(change, Tables.ADGROUPS_MINUS_WORDS.PID) }
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(Tables.ADGROUPS_MINUS_WORDS)
                .setOperation(Operation.DELETE)
                .setMapper { change -> mapToPhrasesObject(change, Tables.ADGROUPS_MINUS_WORDS.PID) }
                .build()
        )
    }

    private fun mapToPhrasesObject(proceededChange: ProceededChange, pidColumn: Field<Long>, cidColumn: Field<Long>? = null): BsExportAdGroupObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(pidColumn)
        val debugInfo = extractDebugInfo(proceededChange)
        val campaignId: Long? = cidColumn?.let { proceededChange.getAfter(cidColumn) }
        return BsExportAdGroupObject(AdGroupResourceType.MINUS_PHRASES, adGroupId, campaignId, debugInfo)
    }

    private fun mapToMinusWordsObject(proceededChange: ProceededChange): BsExportAdGroupObject {
        val minusWordId: Long = proceededChange.getPrimaryKey(Tables.MINUS_WORDS.MW_ID)
        val debugInfo = extractDebugInfo(proceededChange)
        val minusPhrasesInfo = MinusPhrasesInfo(minusWordId)
        return BsExportAdGroupObject(AdGroupResourceType.MINUS_PHRASES, null, null, debugInfo, minusPhrasesInfo)
    }
}
