package ru.yandex.direct.ess.router.rules.bsexport.adgroup.filter

import org.jooq.Field
import org.springframework.stereotype.Component
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType.MULTIPLIERS
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.MultiplierInfo
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.RetargetingConditionInfo
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.rules.bsexport.multipliers.MultiplierCommonFilter
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupMultiplierFilter : AdGroupResourceFilter {

    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupObject>) {
        MultiplierCommonFilter.registerCommonChangeHandlers(tableChangesHandler, this::checkPid,
            this::mapPid, this::mapHierarchicalMultiplierId, this::mapRetargetingConditionId)
    }

    private fun checkPid(proceededChange: ProceededChange): Boolean {
        val adGroupId: Long? = proceededChange.getBeforeOrAfter(Tables.HIERARCHICAL_MULTIPLIERS.PID)
        return adGroupId != null
    }

    private fun mapPid(proceededChange: ProceededChange): BsExportAdGroupObject {
        val adGroupId: Long = proceededChange.getBeforeOrAfter(Tables.HIERARCHICAL_MULTIPLIERS.PID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupObject(MULTIPLIERS, adGroupId, null, debugInfo)
    }

    private fun mapHierarchicalMultiplierId(
        proceededChange: ProceededChange, field: Field<Long>): BsExportAdGroupObject {
        val debugInfo = extractDebugInfo(proceededChange)
        val multiplierInfo = MultiplierInfo(
            hierarchicalMultiplierId = MultiplierCommonFilter.getLongField(proceededChange, field)
        )
        return BsExportAdGroupObject(MULTIPLIERS, null, null, debugInfo, multiplierInfo)
    }

    private fun mapRetargetingConditionId(proceededChange: ProceededChange): BsExportAdGroupObject {
        val debugInfo = extractDebugInfo(proceededChange)
        val retargetingInfo = RetargetingConditionInfo(
            retargetingConditionId = proceededChange.getPrimaryKey(Tables.RETARGETING_GOALS.RET_COND_ID)
        )
        return BsExportAdGroupObject(MULTIPLIERS, null, null, debugInfo, retargetingInfo)
    }
}
