package ru.yandex.direct.ess.router.rules.bsexport.adgroup.filter

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.ADGROUP_BS_TAGS
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType.PAGE_GROUP_TAGS
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupPageGroupTagsFilter : AdGroupResourceFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(ADGROUP_BS_TAGS)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(ADGROUP_BS_TAGS)
                .setColumn(ADGROUP_BS_TAGS.PAGE_GROUP_TAGS_JSON)
                .setOperation(Operation.UPDATE)
                .setMapper(this::mapToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(ADGROUP_BS_TAGS)
                .setOperation(Operation.DELETE)
                .setMapper(this::mapToObject)
                .build()
        )
    }

    private fun mapToObject(proceededChange: ProceededChange): BsExportAdGroupObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(ADGROUP_BS_TAGS.PID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupObject(PAGE_GROUP_TAGS, adGroupId, null, debugInfo)
    }
}
