package ru.yandex.direct.ess.router.rules.bsexport.adgroup.filter

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupRelevanceMatchDataFilter : AdGroupResourceFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(Tables.ADGROUPS_DYNAMIC)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(Tables.ADGROUPS_DYNAMIC)
                .setOperation(Operation.UPDATE)
                .setColumn(Tables.ADGROUPS_DYNAMIC.RELEVANCE_MATCH_CATEGORIES)
                .setMapper(this::mapToObject)
                .build()
        )
    }

    private fun mapToObject(proceededChange: ProceededChange): BsExportAdGroupObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(Tables.ADGROUPS_DYNAMIC.PID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupObject(AdGroupResourceType.RELEVANCE_MATCH_DATA, adGroupId, null, debugInfo)
    }
}
