package ru.yandex.direct.ess.router.rules.bsexport.adgroup.filter

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS
import ru.yandex.direct.dbschema.ppc.Tables.PHRASES
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType.SERP_PLACEMENT_TYPE
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupSerpPlacementTypeFilter : AdGroupResourceFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(PHRASES)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapToAdGroupObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(CAMP_OPTIONS)
                .setColumn(CAMP_OPTIONS.PLACEMENT_TYPES)
                .setOperation(Operation.UPDATE)
                .setMapper(this::mapToCampaignObject)
                .build()
        )
    }

    private fun mapToAdGroupObject(proceededChange: ProceededChange): BsExportAdGroupObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(PHRASES.PID)
        val campaignId: Long = proceededChange.getAfter(PHRASES.CID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupObject(SERP_PLACEMENT_TYPE, adGroupId, campaignId, debugInfo)
    }

    private fun mapToCampaignObject(proceededChange: ProceededChange): BsExportAdGroupObject {
        val campaignId: Long = proceededChange.getPrimaryKey(CAMP_OPTIONS.CID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupObject(SERP_PLACEMENT_TYPE, null, campaignId, debugInfo)
    }
}
