package ru.yandex.direct.ess.router.rules.bsexport.adgroup.filter

import org.jooq.Field
import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.ADGROUP_BS_TAGS
import ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS
import ru.yandex.direct.dbschema.ppc.Tables.PHRASES
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType.TARGET_TAGS
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupTargetTagsFilter : AdGroupResourceFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(ADGROUP_BS_TAGS)
                .setOperation(Operation.INSERT)
                .setMapper { mapToAdGroupObject(it, ADGROUP_BS_TAGS.PID) }
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(ADGROUP_BS_TAGS)
                .setColumn(ADGROUP_BS_TAGS.TARGET_TAGS_JSON)
                .setOperation(Operation.UPDATE)
                .setMapper { mapToAdGroupObject(it, ADGROUP_BS_TAGS.PID) }
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(ADGROUP_BS_TAGS)
                .setOperation(Operation.DELETE)
                .setMapper { mapToAdGroupObject(it, ADGROUP_BS_TAGS.PID) }
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(PHRASES)
                .setOperation(Operation.INSERT)
                .setMapper { mapToAdGroupObject(it, PHRASES.PID, PHRASES.CID) }
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(CAMP_OPTIONS)
                .setColumn(CAMP_OPTIONS.PLACEMENT_TYPES)
                .setOperation(Operation.UPDATE)
                .setMapper(this::mapToCampaignObject)
                .build()
        )
    }

    private fun mapToAdGroupObject(
        proceededChange: ProceededChange,
        adGroupIdField: Field<Long>,
        campaignIdField: Field<Long>? = null
    ): BsExportAdGroupObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(adGroupIdField)
        val campaignId: Long? = campaignIdField?.let { proceededChange.getAfter(it) }
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupObject(TARGET_TAGS, adGroupId, campaignId, debugInfo)
    }

    private fun mapToCampaignObject(
        proceededChange: ProceededChange
    ): BsExportAdGroupObject {
        val campaignId: Long = proceededChange.getPrimaryKey(CAMP_OPTIONS.CID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupObject(TARGET_TAGS, null, campaignId, debugInfo)
    }
}
