package ru.yandex.direct.ess.router.rules.bsexport.adgroup.filter

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.ADGROUPS_TEXT
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ColumnsChangeType
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupTextFieldsFilter : AdGroupResourceFilter {

    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(ADGROUPS_TEXT)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupObject>()
                .setTable(ADGROUPS_TEXT)
                .setOperation(Operation.UPDATE)
                .setColumns(
                    ColumnsChangeType.ANY,
                    listOf(ADGROUPS_TEXT.FEED_ID,
                        ADGROUPS_TEXT.FIELD_TO_USE_AS_NAME, ADGROUPS_TEXT.FIELD_TO_USE_AS_BODY)
                )
                .setMapper(this::mapToObject)
                .build()
        )
    }

    private fun mapToObject(proceededChange: ProceededChange): BsExportAdGroupObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(ADGROUPS_TEXT.PID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupObject(AdGroupResourceType.TEXT_FIELDS, adGroupId, null, debugInfo)
    }
}
