package ru.yandex.direct.ess.router.rules.bsexport.adgroup.showconditions

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType
import ru.yandex.direct.dbschema.ppc.Tables.ADGROUP_ADDITIONAL_TARGETINGS
import ru.yandex.direct.dbschema.ppc.Tables.MOBILE_CONTENT
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupShowConditionType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ColumnsChangeType
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupShowConditionAdditionalTargetingFilter : AdGroupShowConditionFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupShowConditionObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(ADGROUP_ADDITIONAL_TARGETINGS)
                .setOperation(Operation.INSERT)
                .setValuesFilter(this::filterUnknownTargetingType)
                .setMapper(this::additionalTargetingToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(ADGROUP_ADDITIONAL_TARGETINGS)
                .setOperation(Operation.DELETE)
                .setValuesFilter(this::filterUnknownTargetingType)
                .setMapper(this::additionalTargetingToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(ADGROUP_ADDITIONAL_TARGETINGS)
                .setOperation(Operation.UPDATE)
                .setValuesFilter(this::filterUnknownTargetingType)
                .setMapper(this::additionalTargetingToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(MOBILE_CONTENT)
                .setOperation(Operation.UPDATE)
                .setColumns(ColumnsChangeType.ANY, listOf(
                    MOBILE_CONTENT.OS_TYPE,
                    MOBILE_CONTENT.BUNDLE_ID,
                    MOBILE_CONTENT.STORE_CONTENT_ID,
                ))
                .setMapper(this::mobileContentToObject)
                .build()
        )
    }

    private val knownTargetingTypes = AdgroupAdditionalTargetingsTargetingType.values().map { it.name }.toSet()

    private fun filterUnknownTargetingType(proceededChange: ProceededChange): Boolean {
        val targetingTypeStr: String = proceededChange.getBeforeOrAfter(ADGROUP_ADDITIONAL_TARGETINGS.TARGETING_TYPE)
        return knownTargetingTypes.contains(targetingTypeStr)
    }

    private fun additionalTargetingToObject(proceededChange: ProceededChange): BsExportAdGroupShowConditionObject {
        val targetingType: AdgroupAdditionalTargetingsTargetingType = AdgroupAdditionalTargetingsTargetingType.valueOf(
            proceededChange.getBeforeOrAfter(ADGROUP_ADDITIONAL_TARGETINGS.TARGETING_TYPE))
        val adGroupId: Long = proceededChange.getBeforeOrAfter(ADGROUP_ADDITIONAL_TARGETINGS.PID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupShowConditionObject(
            adGroupId,
            campaignId = null,
            AdGroupShowConditionType.ADDITIONAL_TARGETING,
            debugInfo,
            targetingType
        )
    }

    private fun mobileContentToObject(proceededChange: ProceededChange): BsExportAdGroupShowConditionObject {
        val mobileContentId: Long = proceededChange.getLongPrimaryKey(MOBILE_CONTENT.MOBILE_CONTENT_ID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupShowConditionObject(
            adGroupId = null,
            campaignId = null,
            AdGroupShowConditionType.ADDITIONAL_TARGETING,
            debugInfo,
            mobileContentId = mobileContentId
        )
    }
}
